	TITLE	'MDBS/PLI CALL INTERFACE PROGRAM'
;PROGRAM
;		MDBS/PLI CALL INTERFACE PROGRAM
;PROGRAMMER
;		ROBERT M. WHITE
;DATE WRITTEN
;		JULY 21, 1980
;(C)COPYRIGHT	1980,H & W COMPUTER SYSTEMS, INC.
;PURPOSE
;		THIS ROUTINE PERFORMS THE FUNCTION OF INTERFACING MDBS WITH
;		THE PL/1 PROGRAM.  IT IS A LINKABLE MODULE THAT EXPECTS THE
;		MDBS NUCLEUS TO START AT 8003H IN MEMORY.
;REMARKS


	MACLIB	MACRO
DFCB	EQU	005CH		;DEFAULT FCB

;		DO INITIALIZATION.
	NAME	'MDBSCL'
MDBSCL:	CSEG
	PUBLIC	MDBSCL

;		GET THE FUNCTION CODE.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;GET FUNCTION CODE.
	MOV	A,M
	STA	FUNC
	XCHG

;		GET THE BC PARM.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE THE PARM.
	SHLD	BCPARM
	XCHG

;		GET THE DE PARM.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE THE PARM.
	SHLD	DEPARM
	XCHG

;		GET THE HL PARM.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE THE PARM.
	SHLD	HLPARM
	XCHG

;		GET THE RETURN CODE PTR.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	RTNCDP
	XCHG

;		GET THE RECORD PTR.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	PUSH	H
	XCHG			;GET VALUE OF PTR.
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;SAVE RECORD PTR.
	SHLD	RCDPTR
	POP	H		;RESTORE PARM PTR.

;		GET THE RECORD LENGTH.
	MOV	E,M		;GET ADDR OF IT.
	INX	H
	MOV	D,M
	INX	H
	PUSH	H
	XCHG			;GET THE LENGTH.
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;SAVE IT.
	SHLD	RCDLEN
	POP	H		;RESTORE PARM PTR.

;		IF SELECTED FUNC, PUT RECORD AS HL PARM.
	LDA	FUNC		;GET FUNCTION CODE.
	CPI	07		;CRS?
	JZ	USERCD		;...YES.
	CPI	14		;FINDM?
	JZ	USERCD		;...YES.
	CPI	15		;FINDO?
	JZ	USERCD		;...YES.
	CPI	18		;FMSK?
	JZ	USERCD		;...YES.
	CPI	21		;FOSK?
	JZ	USERCD		;...YES.
	CPI	38		;PUTC?
	JZ	USERCD		;...YES.
	CPI	39		;PUTM?
	JZ	USERCD		;...YES.
	CPI	40		;PUTO?
	JZ	USERCD		;...YES.
	CPI	41		;PUTR?
	JZ	USERCD		;...YES.
	CPI	47		;SFC?
	JZ	USERCD		;...YES.
	CPI	48		;SFM?
	JZ	USERCD		;...YES.
	CPI	49		;SFO?
	JZ	USERCD		;...YES.
	CPI	50		;SFR?
	JZ	USERCD		;...YES.
	JMP	BYPRCD		;...NO, DON'T USE RECORD.
USERCD:
	LHLD	RCDPTR		;GET RECORD PTR.
	SHLD	HLPARM		;PUT IT IN HL PARM.
BYPRCD:

;		CALL MDBS WITH PARM.
	LHLD	BCPARM		;LOAD BC PARM.
	MOV	B,H
	MOV	C,L
	LHLD	DEPARM		;LOAD DE PARM.
	MOV	D,H
	MOV	E,L
	LHLD	HLPARM		;LOAD HL PARM.
	LDA	FUNC		;GET FUNCTION CODE.

;		CALL MDBS.
	PUSH	H		;SAVE CURRENT HL.
	LXI	H,RETRN		;SET RETURN ADDRESS.
	XTHL
	PUSH	H		;SAVE CURRENT HL AGAIN.
	LHLD	6		;CALCULATE ADDRESS OF MDBS.
	INX	H
	INX	H
	INX	H
	XTHL			;SET THE ENTRY ADDRESS.
	RET			;CALL MDBS.
RETRN  	DS	0

;		SAVE RETURN PARAMETERS AND RETURN CODE.
	STA	RETCOD		;SAVE RETURN CODE.
	SHLD	HLRPRM		;SAVE HL RETURN PARM.
	MOV	H,D		;SAVE DE RETURN PARM.
	MOV	L,E
	SHLD	DERPRM
	MOV	H,B		;SAVE BC RETURN PARM.
	MOV	L,C
	SHLD	BCRPRM

;		IF ZERO RETURN CODE AND GET FUNC, MOVE RECORD.
	ORA	A		;ZERO RETURN CODE?
	JNZ	MOVBYP		;...NO.
	LDA	FUNC		;CHECK FOR GET FUNCTION CODE.
	CPI	24		;LOW?
	JC	MOVBYP		;...YES.
	CPI	36+1		;HIGH?
	JNC	MOVBYP		;...YES.
	CPI	32		;GMC?
	JZ	MOVBYP		;...YES.
	CPI	33		;GOC?
	JZ	MOVBYP		;...YES.
	LHLD	RCDLEN		;BC=RECORD LENGTH
	MOV	B,H
	MOV	C,L
	LHLD	RCDPTR		;DE => RECORD AREA
	XCHG
	LHLD	HLRPRM		;HL => RECORD IN BUFFER
	MOVE			;MOVE THE RECORD FROM THE BUFFER.
MOVBYP:

;		RETURN TO CALLER.
	LHLD	RTNCDP		;SET RETURN CODE.
	LDA	RETCOD
	MOV	M,A
	RET			;RETURN TO CALLER.
	PAGE
;****************************************************************
;*			PROGRAM CONSTANTS			*
;****************************************************************

;		INPUT PARM.
MDBSCD:	DSEG
FUNC:	DB	0		;FUNCTION CODE
BCPARM: DW	0		;BC PARM
DEPARM:	DW	0		;DE PARM
HLPARM:	DW	0		;HL PARM
RTNCDP:	DW	0		;RETURN CODE PTR
RCDPTR:	DW	0		;RECORD PTR
RCDLEN:	DW	0		;RECORD LENGTH

;		RETURN PARMS.
RETCOD:	DB	0		;RECORD CODE.
BCRPRM:	DW	0		;BC PARM
DERPRM:	DW	0		;DE PARM
HLRPRM:	DW	0		;HL PARM

	END
